<?php
/*
* Plugin Name: Constant Contact LeadGen & CRM Contact Form 7 Connection
* Description: Connect Contact Form 7 to LeadGen & CRM from Constant Contact
* Version: 1.1
* Author: Constant Contact Lead Gen and CRM Support
*/

// Define th function that handles submitting ot LeadGen. $data is the form data provided from CF7
function submitToLeadGen($data, $baseURI, $endPoint, $track = true) {
  unset($data['_wpcf7']);
  unset($data['_wpcf7_version']);
  unset($data['_wpcf7_locale']);
  unset($data['_wpcf7_unit_tag']);
  unset($data['_wpcf7_container_post']);


   $params = '';
  foreach($data as $key => $value) {
    // Skip the hidden fields with base uri and endpoint when getting form field data
  	if ($key != 'base_uri' && $key != 'endpoint') {
      // If not an array, add the field label ($key) to the query string, followed by = and the value
    	if(!is_array($value)) {
      		$params = $params . $key . '=' . urlencode($value) . "&";
      // If it is an array, it is a checkbox group. Convert to a comma-separated list as LeadGen needs to receive
        } else {
    		$params = $params . $key . '=' . urlencode(implode(',',$value)) . "&";    
    	}
   	}
  }

  // Gather the tracking cookie
  if (isset($_COOKIE['__ss_tk'])) {
    $trackingid__sb = $_COOKIE['__ss_tk'];
    $params = $params . "trackingid__sb=" . urlencode($trackingid__sb);
  }
  // Form the entire request URL as it will be sent to the LeadGen endpoint, and make the network request.
  $leadGenReq = $baseURI . $endPoint . "/jsonp/?" . $params;
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $leadGenReq); 
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  $result = curl_exec($ch);
  ob_start();
  var_dump($data);
  $data_dump = ob_get_clean();
  curl_close($ch);
}

// Enable the submission listener defined by CF7. Note that before_mail_send is used rather than submission.
// This does not rely on any actual mail being sent, but simply triggers it after validation has passed,
// while the submission listener fires pre-validation.
add_action( 'wpcf7_before_send_mail', function ($cf7) {
	$body = [];
	$body['POST_DATA'] = $_POST;

  // Gather baseURI and endpoint from the hidden fields
	if (isset($body['POST_DATA']['base_uri'])) {
        $baseURI = $body['POST_DATA']['base_uri'];
		
	}
	if (isset($body['POST_DATA']['endpoint'])) {
        $endpoint = $body['POST_DATA']['endpoint'];
    // Only attempt to submit to LeadGen if the endpoint field is present. Used to keep forms that shouldn't be connected from submitting.
		$sendToLeadGen = true;
	}

  // Check to see if a hidden field called support_test is present, if so, enable test mode for Support
  if (isset($body['POST_DATA']['support_test'])) {
        $endpointTest = $body['POST_DATA']['support_test'];
    $testMode = true;
  }

  // Run the function to form the query string and submit it to LeadGen
	if ($sendToLeadGen) {
	     submitToLeadGen($_POST, $baseURI, $endpoint);
	}

  // If test mode is enabled, also send the submission to the specified URL in the support_test hidden field.
  // This will be exactly what is being sent to our form, and can be checked using Requestbin or similar.
  if ($testMode) {
       submitToLeadGen($_POST, $endpointTest, '');
  }


});
?>